<?php
/*--------------------------------------------------------------------
 CombinationModelDto.php 2020-2-20
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Properties\SellingUnitModel\Database\Repository\DTO;

/**
 * Class CombinationModelDto
 * @package Gambio\Shop\Properties\SellingUnitModel\Database\Repository\DTO
 */
class CombinationModelDto
{
    /**
     * @var string
     */
    protected $valueModel;
    
    
    /**
     * CombinationModelDto constructor.
     *
     * @param string $valueModel
     */
    public function __construct(string $valueModel)
    {
        $this->valueModel = $valueModel;
    }
    
    
    /**
     * @return string
     */
    public function combinationModel(): string
    {
        return $this->valueModel;
    }
}